VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   3120
   ClientLeft      =   60
   ClientTop       =   420
   ClientWidth     =   4680
   LinkTopic       =   "Form1"
   ScaleHeight     =   3120
   ScaleWidth      =   4680
   StartUpPosition =   2  'Bildschirmmitte
   Begin VB.CommandButton Command1 
      Caption         =   "Create PDF"
      Height          =   855
      Left            =   960
      TabIndex        =   0
      Top             =   960
      Width           =   2775
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Private Declare Function ShellExecuteA Lib "shell32.dll" (ByVal hWnd As Long, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long

Private WithEvents pdf As CPDF 'Activate event support
Attribute pdf.VB_VarHelpID = -1

Private Sub pdf_Error(ByVal Description As String, ByVal ErrType As Long, DoBreak As Boolean)
   MsgBox Description, vbExclamation, "Error"
   DoBreak = False ' Try to continue
End Sub

' Incremental updates are useful if small changes should be saved quickly, e.g. when adding an annotation or reply to one,
' adding form fields and so on.

' This example is a bit simplified since we know that the file contains only one annotation and a handle of an annotation
' is just an array index from 0 though annotation count -1.

Function CreateTestFile() As Byte()

   Call pdf.CreateNewPDF(vbNullString)

   Call pdf.SetPageCoords(TPageCoord.pcTopDown)

   Call pdf.Append
      Call pdf.SquareAnnot(50#, 50#, 200#, 100#, 3#, NO_COLOR, 255, csDeviceRGB, "Jim", "Test", "Just test...")
   Call pdf.EndPage

   If Not pdf.CloseFile Then Exit Function
   ' This function creates a copy of the buffer and this is exactly what we need in this example.
   CreateTestFile = pdf.GetBuffer()

   ' We can release the original buffer. This also resets the PDF instance,
   ' just as CloseFile() would do if the file would be created on a local drive.
   Call pdf.FreePDF
End Function

Function LoadTestFile(buffer() As Byte) As Boolean
   LoadTestFile = False
   Call pdf.CreateNewPDF(vbNullString)
   ' This flag also sets the flags ifImportAsPage | ifImportAll, and if2UseProxy | if2CopyEncryptDict to make sure that
   ' anything is imported and nothing gets changed.
   Call pdf.SetImportFlags2(if2IncrementalUpd)
   If pdf.OpenImportBuffer(buffer, ptOpen, vbNullString) < 0 Then Exit Function
   LoadTestFile = pdf.ImportPDFFile(1, 1#, 1#) > 0
End Function

Function SaveFile() As Byte()
   If Not pdf.CloseFile() Then Exit Function
   SaveFile = pdf.GetBuffer()
   ' We can release the original buffer. This also resets the PDF instance,
   ' just as CloseFile() would do if the file would be created on a local drive.
   Call pdf.FreePDF
End Function

Private Sub Command1_Click()
   Dim reply As Long
   Dim buffer() As Byte

   ' We create the base file in memory in this example
   buffer = CreateTestFile()

   ' CreateTest() created a copy of the PDF buffer. We are now the owner of the buffer.
   ' The PDF instance has now it's inital state with the exception that the font cache, if already loaded, stays in memory.
   If LoadTestFile(buffer) Then
      ' We don't need the buffer anymore
      Erase buffer
      ' We do not search for the annotation here since we know that the file contains only one annotation
      ' and the handle of this annotation is zero since this is just an array index.
      reply = pdf.SetAnnotMigrationState(0, TAnnotState.asCreateReply, "Harry")
      Call pdf.SetAnnotString(reply, TAnnotString.asContent, "Hi Jim, your test annotation looks fine!")
      buffer = SaveFile()
      If LoadTestFile(buffer) Then
         Erase buffer

         reply = pdf.SetAnnotMigrationState(reply, TAnnotState.asCreateReply, "Tommy")
         Call pdf.SetAnnotString(reply, TAnnotString.asContent, "Just a test whether I can reply to a reply...")
         buffer = SaveFile()
         If LoadTestFile(buffer) Then
            Erase buffer

            reply = pdf.SetAnnotMigrationState(reply, TAnnotState.asCreateReply, "Jim")
            Call pdf.SetAnnotString(reply, TAnnotString.asContent, "Seems to work very well!")
            ' No fatal error occurred?
            If pdf.HaveOpenDoc() Then
               ' OK, now we can open the output file.
               Dim OutFile As String
               OutFile = App.Path + "\out.pdf"
               If pdf.OpenOutputFile(OutFile) Then
                  If pdf.CloseFile Then
                     ShellExecuteA Me.hWnd, "open", OutFile, vbNullString, vbNullString, 1
                  End If
               End If
            End If
         End If
      End If
   End If
   Set pdf = Nothing
End Sub

Private Sub Form_Load()
   On Error GoTo Err
   Set pdf = New CPDF
   Exit Sub
Err:
   MsgBox "Out of memory!", vbCritical, "Fatal error"
End Sub

Private Sub Form_Terminate()
   Set pdf = Nothing
End Sub
